//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for Samsung Notebooks
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//  Last Update: 02 May 2007
//
public static class SAMSUNG
{

    #region Notebook Samsung P35 : class SP35
    //
    // class author: Manfred Jaider
    //
    public static class SP35
    {

        #region Class for Samsung P35 LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                                // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return SP40.BRIGHTNESS.set_brightness(new_level);                   // we can use the Samsung P40 set_brightness function (brightness control works in the same way)
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                return SP40.BRIGHTNESS.get_brightness(ref level);                   // we can use the Samsung P40 get_brightness function (brightness control works in the same way)
            }
        }
        //
        #endregion

        #region Class for Samsung P35 Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Value class for WLAN_STATUS
            public static class WLAN_STATUS
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_status = 1;                                  // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_status == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0x80);     // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0x81);     // turn on the WLAN
                        }
                    }
                }
            }
        }
        //
        #endregion

        #region Class for Samsung P35 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Buffer for FAN Speed (default value)
            // - - - - - - - - - - -
            //
            // Name (FAN3, Buffer (0x07)
            // {
            //     0x00, 0x00, 0x00, 0xB8, 0xE5, 0xF6, 0xFF                         // 0x00 = FAN OFF;  0xB8 = FAN low speed;  0xE5 = FAN middle speed;  0xF6 = FAN high speed;  0xFF = FAN maximum speed
            // })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 184;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 184;                       // default value, 184 = 0xB8
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.BUFFER.Write("_TZ.FAN3", 3, (byte)fan_low_speed) == true)  // set the fan_low_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 229;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 150;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 229;                       // default value, 229 = 0xE5
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.BUFFER.Write("_TZ.FAN3", 4, (byte)fan_middle_speed) == true)   // set the fan_middle_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 246;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 220;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 246;                       // default value, 246 = 0xF6
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.BUFFER.Write("_TZ.FAN3", 5, (byte)fan_high_speed) == true) // set the fan_high_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (CMP0, Package (0x02)
            // {
            //    Package (0x02)
            //    {
            //        Package (0x0A)    // silent mode package - NOT SUPPORTED
            //        {
            //            0x00, 
            //            0x00, 
            //            0x2D,         // 45°C     <- FAN ON low level
            //            0x48,         // 72°C     <- FAN ON middle level (silent mode)
            //            0x55,         // 85°C     <- FAN ON high level
            //            0x63,         // 99°C     <- FAN ON maximum level
            //            0x69,         // 105°C    <- turn off computer
            //            0x00, 
            //            0x09, 
            //            0x32
            //        }, 
            //
            //        Package (0x07)    // silent mode package - NOT SUPPORTED
            //        {
            //            0x00, 
            //            0x00, 
            //            0x00, 
            //            0x23,         // 35°C     <- FAN OFF low level
            //            0x41,         // 65°C     <- FAN OFF middle level (silent mode)
            //            0x4B,         // 75°C     <- FAN OFF high level
            //            0x5E          // 94°C     <- FAN OFF maximum level
            //        }
            //    }, 
            //
            //    Package (0x02)
            //    {
            //        Package (0x0A)
            //        {
            //            0x00, 
            //            0x00, 
            //            0x2D,         // 45°C     <- FAN ON low level
            //            0x41,         // 65°C     <- FAN ON middle level
            //            0x55,         // 85°C     <- FAN ON high level
            //            0x63,         // 99°C     <- FAN ON maximum level
            //            0x69,         // 105°C    <- turn off computer
            //            0x00, 
            //            0x09, 
            //            0x32
            //        }, 
            //
            //        Package (0x07)
            //        {
            //            0x00, 
            //            0x00, 
            //            0x00, 
            //            0x23,         // 35°C     <- FAN OFF low level
            //            0x37,         // 55°C     <- FAN OFF middle level
            //            0x4B,         // 75°C     <- FAN OFF high level
            //            0x5E          // 94°C     <- FAN OFF maximum level
            //        }
            //    }
            // })

            #region Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 35;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 35;                        // default value, 35 = 0x23
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[1].PKG[1].PKG[3]", low_level_off) == true)  // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 45;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value, 45 = 0x2D
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[1].PKG[0].PKG[2]", low_level_on) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 55;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[1].PKG[1].PKG[4]", middle_level_off) == true)   // set the middle_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 65;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value, 65 = 0x41
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[1].PKG[0].PKG[3]", middle_level_on) == true)    // set the middle_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 75;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 20;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 75;                        // default value, 75 = 0x4B
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[1].PKG[1].PKG[5]", high_level_off) == true)     // set the high_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 85;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 85;                        // default value, 85 = 0x55
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[1].PKG[0].PKG[4]", high_level_on) == true)  // set the high_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.THND");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.THND");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Samsung P40 : class SP40
    //
    // class author: Manfred Jaider
    //
    public static class SP40
    {

        #region Class for Samsung P40 LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                                // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            // 
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                if (get_brightness(ref BRIGHTNESS_LEVEL.brightness_level) == false)     // get the brightness level
                {
                    return false;
                }
                else
                {
                    if (BRIGHTNESS_LEVEL.brightness_level < new_level)
                    {
                        for (int i = (BRIGHTNESS_LEVEL.brightness_level + 1); i <= new_level; i++)
                        {
                            if (ACPI.METHOD.Call("_SB.PCI0.LPCB.EC0._Q68") == false)    // brightness up
                            {
                                return false;       // ERROR
                            }
                        }
                    }
                    else if (BRIGHTNESS_LEVEL.brightness_level > new_level)
                    {
                        for (int i = (BRIGHTNESS_LEVEL.brightness_level - 1); i >= new_level; i--)
                        {
                            if (ACPI.METHOD.Call("_SB.PCI0.LPCB.EC0._Q69") == false)    // brightness down
                            {
                                return false;       // ERROR
                            }
                        }
                    }
                    return true;
                }
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for Samsung P40 Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_STATUS : class WLAN_STATUS
            //
            public static class WLAN_STATUS
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_status = 0;                                  // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_status == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for Samsung P40 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Buffer for FAN Speed (default value)
            // - - - - - - - - - - -
            //
            // Name (FAN3, Buffer (0x07)
            // {
            //     0x00, 0x00, 0x8E, 0x9E, 0xD2, 0xDC, 0xDC                         // 0x00 = FAN OFF;  0x8E = FAN low speed;  0x9E = FAN middle speed;  0xD2 = FAN high speed;  0xDC = FAN very high level;  0xFF = FAN maximum speed
            // })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 142;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 142;                       // default value, 142 = 0x8E
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.BUFFER.Write("_TZ.FAN3", 2, (byte)fan_low_speed) == true)  // set the fan_low_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 158;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 158;                       // default value, 158 = 0x9E
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.BUFFER.Write("_TZ.FAN3", 3, (byte)fan_middle_speed) == true)   // set the fan_middle_speed value in the buffer
                        {
                            if (initialisation == false)
                            {
                                return refresh_thermal_zone();                      // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 210;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 200;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 210;                       // default value, 210 = 0xD2
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.BUFFER.Write("_TZ.FAN3", 4, (byte)fan_high_speed) == true) // set the fan_high_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (CMP0, Package (0x02)
            // {
            //    Package (0x02)
            //    {
            //        Package (0x0A)
            //        {
            //            Zero, 
            //            0x2D,     // 45°C     <- FAN ON low level
            //            0x39,     // 57°C     <- FAN ON middle level
            //            0x44,     // 68°C     <- FAN ON high level
            //            0x54,     // 84°C     <- FAN ON very high level
            //            0x64,     // 100°C    <- FAN ON maximum level
            //            0x69,     // 105°C    <- turn off computer
            //            Zero, 
            //            0x09, 
            //            0x32
            //        }, 
            //
            //        Package (0x07)
            //        {
            //            Zero, 
            //            Zero, 
            //            0x23,     // 35°C     <- FAN OFF low level
            //            0x35,     // 53°C     <- FAN OFF middle level
            //            0x3F,     // 63°C     <- FAN OFF high level
            //            0x51,     // 81°C     <- FAN OFF very high level
            //            0x5E      // 94°C     <- FAN OFF maximum level
            //        }
            //    },

            #region  Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 35;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 35;                        // default value, 35 = 0x23
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[0].PKG[1].PKG[2]", low_level_off) == true)  // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 45;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value, 45 = 0x2D
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[0].PKG[0].PKG[1]", low_level_on) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 53;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value, 53 = 0x35
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[0].PKG[1].PKG[3]", middle_level_off) == true)   // set the middle_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 57;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 57;                        // default value, 57 = 0x39
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[0].PKG[0].PKG[2]", middle_level_on) == true)    // set the middle_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 63;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 20;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 63;                        // default value, 63 = 0x3F
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[0].PKG[1].PKG[4]", high_level_off) == true) // set the high_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 68;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 68;                        // default value, 68 = 0x44
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.CMP0", "PKG[0].PKG[0].PKG[3]", high_level_on) == true)  // set the high_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.THND");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.THND");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Samsung P50 : class SP50
    //
    // class author: Manfred Jaider
    //
    public static class SP50
    {

        #region Class for Samsung P50 Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for TOUCHPAD : class TOUCHPAD
            //
            public static class TOUCHPAD
            {
                // Properties of the value class
                public const string description = "Touchpad";                       // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int touchpad = 0;                                     // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value 
                    public const int nhc_maximum_value = 1;                         // the maximum value
                    public const int nhc_default_value = 1;                         // the default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        
                        int value = 0;
                        if (ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref value, 0x87, 8) == false)     // Read byte from register 0x87 
                        {
                            return false;
                        }
                        
                        if (touchpad == 0)
                        {
                            if ((value & 0x01) != 0x01)     // 0000 000X    <- Check if Bit 0 is not set
                            {
                                value |= 0x09;      // 0000 1001    <- Disable touchpad (set Bit 0) and create Event (set Bit 3)

                                return ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", value, 0x87, 8);          // Write the modified byte to the register 0x87
                            }
                            else
                            {
                                return true;
                            }
                        }
                        else
                        {
                            if ((value & 0x01) != 0x00)     // 0000 000X    <- Check if Bit 0 is not reset
                            {
                                value &= 0xFE;      // 1111 1110    <- Enable touchpad (reset Bit 0) 
                                value |= 0x08;      // 0000 1000    <- Create Event (set Bit 3)

                                return ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", value, 0x87, 8);          // Write the modified byte to the register 0x87
                            }
                            else
                            {
                                return true;
                            }
                       }
                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for Samsung P50 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Condition variables (optional)
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false
            public static bool enable = false;                                      // If NHC or the user enable the class the value is true otherwise the value is false

            #region Value class for FAN_ON_TEMP : class FAN_ON_TEMP
            //
            public static class FAN_ON_TEMP
            {
                // Properties of the value class
                public const string description = "FAN ON Temperature";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_on_temp = 0;                                  // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value
                
                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 45;                        // the minimum value 
                    public const int nhc_maximum_value = 65;                        // the maximum value
                    public const int nhc_default_value = 60;                        // the default value
                }
            }
            //
            #endregion

            #region Value class for FAN_OFF_TEMP : class FAN_OFF_TEMP
            //
            public static class FAN_OFF_TEMP
            {
                // Properties of the value class
                public const string description = "FAN OFF Temperature";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_off_temp = 0;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                                 // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                             // the minimum value 
                    public const int nhc_maximum_value = 60;                            // the maximum value
                    public const int nhc_default_value = 50;                            // the default value
                }
            }
            //
            #endregion

            #region Information class for the FAN : class FAN_RUNNING_QUIETLY
            //
            public static class FAN_RUNNING_QUIETLY
            {
                // Properties of the value class
                public const string description = "FAN running quietly";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_running_quietly = 0;                          // It must have the same name as the class (case are ignored)
                public const string unit = "";                                      // unit of value
            }
            //
            #endregion

            #region Public definition: CPU and System temperatures
            //
            public static int cpu_temperature = 0;
            public static int system_1_temperature = 0;
            public static int system_2_temperature = 0;
            public static int system_3_temperature = 0;
            //
            #endregion

            #region FAN Control highspeed refresh function : highspeed_refresh()
            //            
            private const int TEMP_FAN_RUNNING_QUIETLY = 55;        // On a temperature equal and below 55°C the FAN is running quietly (with and without silent mode)            
            private const int TEMP_HYSTERESIS = 5;                  // If the temperature is equal or higher as (FAN_ON_TEMP.fan_on_temp + TEMP_HYSTERESIS) then the FAN Control is given back to the system
            //
            public const int highspeed_refresh_interval = 1;
            public static bool highspeed_refresh()
            {

                // 1. Get CPU and System temperatures
                //                
                int temp_cpu = 0;
                int temp_system_1 = 0;
                int temp_system_2 = 0;
                int temp_system_3 = 0;
                if (ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref temp_cpu, 0xC0, 8) == false) { return false; }        // get CPU Temperature
                if (ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref temp_system_1, 0xC1, 8) == false) { return false; }   // get system 1 temperature
                if (ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref temp_system_2, 0xC2, 8) == false) { return false; }   // get system 2 temperature
                if (ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref temp_system_3, 0xC3, 8) == false) { return false; }   // get system 3 temperature


                // 2. Save the CPU and System temperatures (only if the CPU temperature is not the same as the last_write CPU temperature)
                //
                if (temp_cpu != 0)
                {
                    cpu_temperature = temp_cpu;
                }
                if (temp_system_1 != 0)
                {
                    system_1_temperature = temp_system_1;
                }
                if (temp_system_2 != 0)
                {
                    system_2_temperature = temp_system_2;
                }
                if (temp_system_3 != 0)
                {
                    system_3_temperature = temp_system_3;
                }


                // 3. Stop the FAN if necessary
                //
                int max_temp = FAN_ON_TEMP.fan_on_temp + TEMP_HYSTERESIS;
                if ((cpu_temperature < max_temp) &&
                    (system_1_temperature < max_temp) &&
                    (system_2_temperature < max_temp) &&
                    (system_3_temperature < max_temp))
                {

                    //  Disable the default Fan Control
                    //
                    if (ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", 0, 0xC0, 8) == false) { return false; }      //  set cpu temperatures to zero to stop the FAN               
                    if (ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", 0, 0xC1, 8) == false) { return false; }      //  set system 1 temperatures to zero to stop the FAN
                    if (ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", 0, 0xC2, 8) == false) { return false; }      //  set system 2 temperatures to zero to stop the FAN
                    if (ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", 0, 0xC3, 8) == false) { return false; }      //  set system 3 temperatures to zero to stop the FAN

                    //  FAN Control
                    //
                    if ((cpu_temperature < FAN_ON_TEMP.fan_on_temp) &&
                        (system_1_temperature < FAN_ON_TEMP.fan_on_temp) &&
                        (system_2_temperature < FAN_ON_TEMP.fan_on_temp) &&
                        (system_3_temperature < FAN_ON_TEMP.fan_on_temp))
                    {

                        if ((cpu_temperature <= FAN_OFF_TEMP.fan_off_temp) &&
                            (system_1_temperature <= FAN_OFF_TEMP.fan_off_temp) &&
                            (system_2_temperature <= FAN_OFF_TEMP.fan_off_temp) &&
                            (system_3_temperature <= FAN_OFF_TEMP.fan_off_temp))
                        {                            
                            FAN_RUNNING_QUIETLY.fan_running_quietly = 0;        // stop the quiet FAN
                        }
                    }
                    else
                    {                        
                        FAN_RUNNING_QUIETLY.fan_running_quietly = 1;            // The quite FAN will run if necessary
                    }

                    //  Should Fan running quietly?
                    //                    
                    if (FAN_RUNNING_QUIETLY.fan_running_quietly == 0)
                    {
                        if (ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", 0, 0xC4, 8) == false) { return false; }        // stop the quiet FAN
                    }
                    else
                    {
                        if (ACPI.FIELD.WriteByOffset("_SB.PCI0.LPCB.H_EC.ECR", TEMP_FAN_RUNNING_QUIETLY, 0xC4, 8) == false) { return false; }        // enable FAN running quitly - by default the value of the register 0xC4 is zero. The FAN controller of the Notbeook will also check this register and control the fan with this register. If we set a higher value then the FAN will run.
                    }
                }

                return true;
            }
            //
            #endregion

        }
        //
        #endregion

        #region Thermal Zone class for CPU Temperature : class TZ00
        //
        public static class TZ00    // If the name of the Thermal Zone class is the same as the name of an existing thermal zone in the system then NHC will overwrite the system thermal zone
        {
            // Info
            public const string description = "CPU Temperature";                    // Description of current class
            public const bool default_enabled = true;                                // false = By default the current class is disabled in NHC
            public const int icon = 5;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon, 5 = Temperature icon
            public const bool thermal_zone = true;                                  // NHC will interpret this class as a Thermal Zone zone class if this value is true

            #region Value class for _TMP : class _TMP
            // 
            public static class _TMP
            {
                // Properties of the value class
                public const string description = "Current Temperature";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value                
                public static int _tmp = 0;                                         // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the example_value class.                
            }
            //
            #endregion

            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                if (FAN.enable == true)
                {
                    _TMP._tmp = FAN.cpu_temperature;
                    return true;
                }
                else
                {
                    return ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref _TMP._tmp, 0xC0, 8);     // get CPU temperature                                     
                }
            }
        }
        //
        #endregion

        #region Thermal Zone class for System Temperature 1 : class TZ01
        //
        public static class TZ01    // If the name of the Thermal Zone class is the same as the name of an existing thermal zone in the system then NHC will overwrite the system thermal zone
        {
            // Info
            public const string description = "System Temperature 1";               // Description of current class
            public const bool default_enabled = true;                                // false = By default the current class is disabled in NHC
            public const int icon = 5;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon, 5 = Temperature icon
            public const bool thermal_zone = true;                                  // NHC will interpret this class as a Thermal Zone zone class if this value is true

            #region Value class for _TMP : class _TMP
            // 
            public static class _TMP
            {
                // Properties of the value class
                public const string description = "Current Temperature";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value                
                public static int _tmp = 0;                                         // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the example_value class.                
            }
            //
            #endregion

            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                if (FAN.enable == true)
                {
                    _TMP._tmp = FAN.system_1_temperature;
                    return true;
                }
                else
                {
                    return ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref _TMP._tmp, 0xC1, 8);    // get System 1 temperature
                }
            }
        }
        //
        #endregion

        #region Thermal Zone class for System Temperature 2 : class TZ02
        //
        public static class TZ02    // If the name of the Thermal Zone class is the same as the name of an existing thermal zone in the system then NHC will overwrite the system thermal zone
        {
            // Info
            public const string description = "System Temperature 2";               // Description of current class
            public const bool default_enabled = true;                                // false = By default the current class is disabled in NHC
            public const int icon = 5;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon, 5 = Temperature icon
            public const bool thermal_zone = true;                                  // NHC will interpret this class as a Thermal Zone zone class if this value is true

            #region Value class for _TMP : class _TMP
            // 
            public static class _TMP
            {
                // Properties of the value class
                public const string description = "Current Temperature";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value                
                public static int _tmp = 0;                                         // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the example_value class.                
            }
            //
            #endregion

            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                if (FAN.enable == true)
                {
                    _TMP._tmp = FAN.system_2_temperature;
                    return true;
                }
                else
                {
                    return ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref _TMP._tmp, 0xC2, 8);     // get System 2 temperature
                }
            }
        }
        //
        #endregion

        #region Thermal Zone class for System Temperature 3 : class TZ03
        //
        public static class TZ03    // If the name of the Thermal Zone class is the same as the name of an existing thermal zone in the system then NHC will overwrite the system thermal zone
        {
            // Info
            public const string description = "System Temperature 3";               // Description of current class
            public const bool default_enabled = true;                                // false = By default the current class is disabled in NHC
            public const int icon = 5;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon, 5 = Temperature icon
            public const bool thermal_zone = true;                                  // NHC will interpret this class as a Thermal Zone zone class if this value is true

            #region Value class for _TMP : class _TMP
            // 
            public static class _TMP
            {
                // Properties of the value class
                public const string description = "Current Temperature";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value                
                public static int _tmp = 0;                                         // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the example_value class.                
            }
            //
            #endregion

            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                if (FAN.enable == true)
                {
                    _TMP._tmp = FAN.system_3_temperature;
                    return true;
                }
                else
                {
                    return ACPI.FIELD.ReadByOffset("_SB.PCI0.LPCB.H_EC.ECR", ref _TMP._tmp, 0xC3, 8);   // get System 3 temperature
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion


}